/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import javazoom.jl.decoder.Equalizer;
import minecrafttransportsimulator.entities.instances.EntityRadio;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.sound.IStreamDecoder;
import minecrafttransportsimulator.sound.MP3Decoder;
import minecrafttransportsimulator.sound.OGGDecoder;
import minecrafttransportsimulator.sound.RadioManager;

public class RadioStation {
    private final RadioManager.RadioSources source;
    private final int index;
    private final boolean randomOrder;
    private final String url;
    private final List<File> musicFiles;
    public String displayText = "";
    public String infoText = "";
    public final Equalizer equalizer;
    private final ConcurrentLinkedQueue<EntityRadio> queuedRadios = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<EntityRadio> playingRadios = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Integer> activeBuffers = new ConcurrentLinkedQueue();
    private volatile LinkingThread linkingThread;
    private volatile DecoderThread decoderThread;
    private volatile int faultedDecodes;

    public RadioStation(int index, boolean randomOrder) {
        this.source = RadioManager.RadioSources.LOCAL;
        this.equalizer = new Equalizer();
        this.index = index;
        this.randomOrder = randomOrder;
        this.url = null;
        this.musicFiles = RadioManager.parseLocalDirectory(index, randomOrder);
        if (this.musicFiles.isEmpty()) {
            this.displayText = "Fewer than " + (index + 1) + " folders in mts_music.\nGo add some!";
        }
        InterfaceManager.soundInterface.addRadioStation(this);
    }

    public RadioStation(String url) {
        this.source = RadioManager.RadioSources.INTERNET;
        this.equalizer = new Equalizer();
        this.index = 0;
        this.randomOrder = false;
        this.url = url;
        if (url.isEmpty()) {
            this.displayText = "No station set for this preset.  Press SET to teach a station.";
        }
        this.musicFiles = new ArrayList<File>();
        InterfaceManager.soundInterface.addRadioStation(this);
    }

    public void addRadio(EntityRadio radio) {
        this.queuedRadios.add(radio);
    }

    public void removeRadio(EntityRadio radio) {
        this.playingRadios.remove(radio);
        this.queuedRadios.remove(radio);
        if (this.playingRadios.isEmpty() && this.queuedRadios.isEmpty() && this.source != RadioManager.RadioSources.LOCAL && this.decoderThread != null) {
            this.decoderThread.kill();
            this.decoderThread = null;
        }
    }

    public void update() {
        if (!this.playingRadios.isEmpty() || !this.queuedRadios.isEmpty()) {
            if (this.linkingThread == null && this.decoderThread == null) {
                if (this.faultedDecodes < 5) {
                    this.startPlayback();
                }
            } else if (this.decoderThread != null && this.decoderThread.initDone) {
                EntityRadio radio;
                Iterator<EntityRadio> iterator;
                int freeBufferIndex = 0;
                if (!this.playingRadios.isEmpty() && (freeBufferIndex = InterfaceManager.soundInterface.getFreeStationBuffer(this.playingRadios)) != 0) {
                    this.activeBuffers.remove(freeBufferIndex);
                    InterfaceManager.soundInterface.deleteBuffer(freeBufferIndex);
                }
                if ((freeBufferIndex != 0 || this.playingRadios.isEmpty()) && !this.queuedRadios.isEmpty()) {
                    iterator = this.queuedRadios.iterator();
                    while (iterator.hasNext()) {
                        radio = iterator.next();
                        if (!radio.position.isDistanceToCloserThan(InterfaceManager.clientInterface.getClientPlayer().getPosition(), 32.0)) continue;
                        radio.start();
                        InterfaceManager.soundInterface.addRadioSound(radio.getPlayingSound(), this.activeBuffers);
                        this.playingRadios.add(radio);
                        iterator.remove();
                    }
                }
                iterator = this.playingRadios.iterator();
                while (iterator.hasNext()) {
                    radio = iterator.next();
                    if (radio.position.isDistanceToCloserThan(InterfaceManager.clientInterface.getClientPlayer().getPosition(), 32.0)) continue;
                    radio.getPlayingSound().stopSound = true;
                    this.queuedRadios.add(radio);
                    iterator.remove();
                }
                if (this.activeBuffers.isEmpty()) {
                    if (this.decoderThread != null) {
                        this.decoderThread.kill();
                    }
                    this.startPlayback();
                }
            }
        }
    }

    private void startPlayback() {
        for (int buffer : this.activeBuffers) {
            InterfaceManager.soundInterface.deleteBuffer(buffer);
        }
        this.activeBuffers.clear();
        this.queuedRadios.addAll(this.playingRadios);
        this.playingRadios.clear();
        if (this.source.equals((Object)RadioManager.RadioSources.LOCAL)) {
            if (this.musicFiles.isEmpty()) {
                this.musicFiles.addAll(RadioManager.parseLocalDirectory(this.index, this.randomOrder));
            }
            this.playFromLocalFiles();
        } else if (!this.url.isEmpty()) {
            this.playFromInternet();
        }
    }

    private void playFromLocalFiles() {
        Iterator<File> iterator = this.musicFiles.iterator();
        while (iterator.hasNext()) {
            try {
                File musicFile = iterator.next();
                if (!musicFile.getName().toLowerCase(Locale.ROOT).endsWith(".mp3")) {
                    iterator.remove();
                    continue;
                }
                this.infoText = "Station: " + this.musicFiles.get(0).getParentFile().getName() + "\nNow Playing: " + this.musicFiles.get(0).getName();
                this.infoText = this.infoText + "\nBuffers:";
                this.decoderThread = new DecoderThread(this, this.musicFiles.get(0));
                this.decoderThread.start();
                iterator.remove();
                return;
            }
            catch (Exception e) {
                iterator.remove();
            }
        }
    }

    private void playFromInternet() {
        this.displayText = "CONNECTING";
        this.decoderThread = null;
        this.linkingThread = new LinkingThread(this);
        this.linkingThread.start();
    }

    private static class DecoderThread
    extends Thread {
        private final RadioStation station;
        private final String contentType;
        private final URLConnection contentConnection;
        private final File contentFile;
        private IStreamDecoder decoder;
        private boolean stopDecoding;
        public boolean initDone;

        public DecoderThread(RadioStation station, String contentType, URLConnection contentConnection) {
            this.station = station;
            this.contentType = contentType;
            this.contentConnection = contentConnection;
            this.contentFile = null;
        }

        public DecoderThread(RadioStation station, File contentFile) {
            this.station = station;
            this.contentType = null;
            this.contentConnection = null;
            this.contentFile = contentFile;
        }

        @Override
        public void run() {
            int tryCount = 0;
            while (true) {
                try {
                    this.station.displayText = "BUFFERING - TRY #" + tryCount;
                    if (this.contentConnection != null) {
                        switch (this.contentType) {
                            case "audio/mpeg": {
                                this.decoder = new MP3Decoder(this.contentConnection.getInputStream(), this.station.equalizer);
                                break;
                            }
                            case "application/ogg": {
                                this.decoder = new OGGDecoder(this.contentConnection.getInputStream());
                            }
                        }
                    } else {
                        this.decoder = new MP3Decoder(Files.newInputStream(this.contentFile.toPath(), new OpenOption[0]), this.station.equalizer);
                    }
                    for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
                        this.generateBufferIndex(false);
                    }
                    this.initDone = true;
                    this.station.displayText = this.station.infoText;
                    while (!this.stopDecoding) {
                        int newIndex;
                        if (this.station.activeBuffers.size() >= 5 || (newIndex = this.generateBufferIndex(true)) == 0) continue;
                        this.station.playingRadios.forEach(radio -> InterfaceManager.soundInterface.bindBuffer(radio.getPlayingSound(), newIndex));
                    }
                    return;
                }
                catch (Exception exception) {
                    if (++tryCount < 5) continue;
                    this.station.displayText = "ERROR: Was able to connect to URL but not open stream.  Try again later?";
                    this.station.queuedRadios.clear();
                    return;
                }
                break;
            }
        }

        public void kill() {
            this.stopDecoding = true;
            if (this.decoder != null) {
                this.decoder.stop();
            }
        }

        private int generateBufferIndex(boolean updateDisplay) {
            ByteBuffer buffer = this.decoder.readBlock();
            if (buffer != null) {
                int bufferIndex = InterfaceManager.soundInterface.createBuffer(buffer, this.decoder);
                this.station.activeBuffers.add(bufferIndex);
                if (updateDisplay) {
                    int bufferTextIndex = this.station.displayText.indexOf("Buffers:");
                    if (bufferTextIndex != -1) {
                        this.station.displayText = this.station.displayText.substring(0, bufferTextIndex + "Buffers:".length());
                        for (int i = 0; i < this.station.activeBuffers.size(); i = (int)((byte)(i + 1))) {
                            this.station.displayText = this.station.displayText + "X";
                        }
                    } else {
                        this.station.displayText = "DISPLAY MALFUNCTION!\nTURN RADIO OFF AND ON TO RESET!";
                    }
                }
                return bufferIndex;
            }
            return 0;
        }
    }

    private static class LinkingThread
    extends Thread {
        private final RadioStation station;

        private LinkingThread(RadioStation station) {
            this.station = station;
        }

        @Override
        public void run() {
            if (!this.initDecoderThread()) {
                this.station.queuedRadios.clear();
            }
            this.station.linkingThread = null;
        }

        private boolean initDecoderThread() {
            int tryCount = 0;
            String errorString = null;
            block13: do {
                try {
                    URL urlObj = new URL(this.station.url);
                    URLConnection connection = urlObj.openConnection();
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                    connection.connect();
                    this.station.displayText = "CONNECTING - TRY #" + tryCount;
                    String contentType = connection.getContentType();
                    if (contentType == null) {
                        errorString = "ERROR: No content-type header found.  Contact the mod author for more information.";
                        continue;
                    }
                    switch (contentType) {
                        case "audio/mpeg": 
                        case "application/ogg": {
                            break;
                        }
                        case "audio/x-wav": {
                            this.station.displayText = "ERROR: WAV file format not supported...yet.  Contact the mod author.";
                            return false;
                        }
                        case "audio/flac": {
                            this.station.displayText = "ERROR: Who the heck streams in FLAC?  Contact the mod author.";
                            return false;
                        }
                        default: {
                            if (contentType.startsWith("audio")) {
                                this.station.displayText = "ERROR: Unsupported audio format of " + contentType + ".  Contact the mod author.";
                                return false;
                            }
                            errorString = "ERROR: Format " + contentType + " is NOT an audio format.  Is this really a music URL?";
                            continue block13;
                        }
                    }
                    this.station.infoText = "Name: " + (connection.getHeaderField("icy-name") != null ? connection.getHeaderField("icy-name") : "");
                    this.station.infoText = this.station.infoText + "\nDesc: " + (connection.getHeaderField("icy-description") != null ? connection.getHeaderField("icy-description") : "");
                    this.station.infoText = this.station.infoText + "\nGenre: " + (connection.getHeaderField("icy-genre") != null ? connection.getHeaderField("icy-genre") : "");
                    this.station.infoText = this.station.infoText + "\nBuffers:";
                    this.station.decoderThread = new DecoderThread(this.station, contentType, connection);
                    this.station.decoderThread.start();
                    return true;
                }
                catch (Exception e) {
                    this.station.displayText = "ERROR: Unable to open URL.  Have you tried playing it in another application first?";
                    return false;
                }
            } while (++tryCount < 5 && errorString != null);
            this.station.displayText = errorString;
            return false;
        }
    }
}

